// prosty modu serwera
// komunikacji za pomoc Winsock
// uycie: server.exe

#include <winsock2.h>
#include <stdio.h>
#include <stdlib.h>

#define DEFAULT_PORT 5000
#define DEFAULT_BUFFER 4096

// tylko Visual C++
#pragma comment(lib, "ws2_32.lib")

// funkcja: wtek do komunikacji z klientem
DWORD WINAPI ClientThread(LPVOID lpParam)
{
    SOCKET sock = (SOCKET)lpParam;
    char szBuf[DEFAULT_BUFFER];
    int ret,
        nLeft,
        idx;

// serwer bdzie oczekiwa na informacje od klienta
while(1)
{
    // najpierw odbierz dane 
    ret = recv(sock, szBuf, DEFAULT_BUFFER, 0);
    if (ret == 0)
        break; 
    else if (ret == SOCKET_ERROR)
    {
        printf("bd funkcji recv(): %d\n", WSAGetLastError());
        break; 
    } 

    szBuf[ret] = '\0';
    printf("RECV: '%s'\n", szBuf);

    // nastpnie odelij te dane, poporcjuj jeli trzeba
    // (niestety send() moe nie wysa wszystkiego)
    nLeft = ret;
    idx = 0;
    while(nLeft > 0)
    {
        ret = send(sock, &szBuf[idx], nLeft, 0);
        if (ret == 0)
            break;
        else if (ret == SOCKET_ERROR)
        {
            printf("bd funkcji send(): %d\n", WSAGetLastError());
            break; 
        } 
        nLeft -= ret;
        idx += ret;
    }
} 
return 0; 
}

int main(int argc, char *argv[])
{
    WSADATA wsd;
    SOCKET sListen,
    sClient;
    int iAddrSize;
    HANDLE hThread;
    DWORD dwThreadID;
    struct sockaddr_in local, client; 
    struct hostent *host = NULL;

// inicjuj Winsock 2.2 
if (WSAStartup(MAKEWORD(2,2), &wsd) != 0)
{
    printf("Bd adowania Winsock 2.2!\n");
    return 1;
}

// twrz gniazdo do nasuchu pocze klientw
sListen = socket(AF_INET, SOCK_STREAM, IPPROTO_IP);
if (sListen == SOCKET_ERROR) 
{
    printf("Bd funkcji socket(): %d\n", WSAGetLastError());
    return 1;
}

// wybierz interfejs (warstw komunikacyjn)
local.sin_addr.s_addr = htonl(INADDR_ANY);
local.sin_family = AF_INET;
local.sin_port = htons(DEFAULT_PORT); 
if (bind(sListen, (struct sockaddr *)&local, sizeof(local)) == SOCKET_ERROR)
{
    printf("Bd funkcji bind(): %d\n", WSAGetLastError());
    return 1;
}

// nasuch
host = gethostbyname("localhost");
if (host == NULL)
{
    printf("Nie udao si wydoby nazwy serwera\n");
    return 1;
}

listen(sListen, 8);
printf("Serwer nasuchuje.\n");
printf("Adres: %s, port: %d\n", host->h_name, DEFAULT_PORT);

// akceptuj nadchodzce poczenia
while (1)
{
    iAddrSize = sizeof(client);
    sClient = accept(sListen, (struct sockaddr *)&client, &iAddrSize);
    if (sClient == INVALID_SOCKET)
    {
        printf("Bd funkcji accept(): %d\n", WSAGetLastError());
        return 1;
    }
    printf("Zaakceptowano poczenie: serwer %s, port %d\n", 
        inet_ntoa(client.sin_addr), ntohs(client.sin_port));
    hThread = CreateThread(NULL, 0, ClientThread,
        (LPVOID)sClient, 0, &dwThreadID);
    if (hThread == NULL)
    {
        printf("Bd funkcji CreateThread(): %d\n", WSAGetLastError());
        return 1;
    } 
    CloseHandle(hThread); 
} 
closesocket(sListen);

WSACleanup();
return 0;
}
